

<?php $__env->startSection('title'); ?>
Dashboard
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>
    <div class="container">

        <section class="section">
            <div class="section__title d-none">
                <h2>Section</h2>
            </div>
            <div class="row gutter-bottom-xl">
                <div class="col-12 col-lg-7 col-xl-8 d-flex">
                    <div class="card card--lg">
                        <div class="card__wrapper">
                            <div class="card__container">
                                <div class="card__header">
                                    <div class="card__header-left">
                                        <h3 class="card__header-title">Account Balance</h3>
                                    </div>
                                    <div class="card__tools">
                                        <div class="card__tools-row row row--xs gutter-bottom-xs">
                                            <div class="card__tools-switcher col">
                                                <div class="switcher-button">
                                                    <div class="switcher-button__items">
                                                        <div class="switcher-button__float"></div>
                                                        <div class="switcher-button__item">
                                                            <button class="switcher-button__btn">Daily</button>
                                                        </div>
                                                        <div class="switcher-button__item active">
                                                            <button class="switcher-button__btn">Weekly</button>
                                                        </div>
                                                        <div class="switcher-button__item">
                                                            <button class="switcher-button__btn">Monthly</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card__tools-more">
                                        <button class="items-more__button">
                                            <svg class="icon-icon-more">
                                                <use xlink:href="#icon-more"></use>
                                            </svg>
                                        </button>
                                        <div class="dropdown-items">
                                            <div class="dropdown-items__container">
                                                <ul class="dropdown-items__list">
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-refresh">
                                        <use xlink:href="#icon-refresh"></use>
                                      </svg></span>Refresh</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-settings">
                                        <use xlink:href="#icon-settings"></use>
                                      </svg></span>Settings</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-download">
                                        <use xlink:href="#icon-download"></use>
                                      </svg></span>Download</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-action">
                                        <use xlink:href="#icon-action"></use>
                                      </svg></span>Action</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__body">
                                    <div class="card__widgets">
                                        <div class="card__widgets-row gutter-bottom-sm">
                                            <div class="card-widget card-widget--xl">
                                                <h4 class="card-widget__title"><?php echo e(Auth::user()->acctype); ?></h4>
                                                <div class="card-widget__trade"><span class="card-widget__count">$<?php echo e(number_format(Auth::user()->accbal, 0)); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card__countries-progressbar">
                                        <div class="progressbar progressbar--stacked progressbar--axis-top progressbar--lg">
                                            <div class="progressbar__items">
                                                <div class="progressbar__bar progressbar__bar--green" style="width: 40%;"><span class="progressbar__bar-count">$70,000</span>
                                                </div>
                                                <div class="progressbar__bar progressbar__bar--orange" style="width: 20%;"><span class="progressbar__bar-count">$55,000</span>
                                                </div>
                                                <div class="progressbar__bar progressbar__bar--red" style="width: 20%;"><span class="progressbar__bar-count">$40,000</span>
                                                </div>
                                                <div class="progressbar__bar progressbar__bar--orange-dark" style="width: 10%;"><span class="progressbar__bar-count">$25,000</span>
                                                </div>
                                                <div class="progressbar__bar progressbar__bar--teal" style="width: 10%;"><span class="progressbar__bar-count">$20,000</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__footer card__footer--lg">
                                    <div class="card__container">
                                        <div class="country-legend">
                                            <div class="country-legend__row">
                                                <div class="country-legend__item">
                                                    <div class="country-legend__left"><span class="country-legend__marker color-green"></span><span class="country-legend__name">Russia</span>
                                                    </div>
                                                    <div class="country-legend__trade"><span class="country-legend__quot quotation quotation--up">
                                    <svg class="icon-icon-arrow-down">
                                      <use xlink:href="#icon-arrow-down"></use>
                                    </svg></span><span class="country-legend__percentage">40%</span>
                                                    </div>
                                                </div>
                                                <div class="country-legend__item">
                                                    <div class="country-legend__left"><span class="country-legend__marker color-orange"></span><span class="country-legend__name">Australia</span>
                                                    </div>
                                                    <div class="country-legend__trade"><span class="country-legend__quot quotation quotation--down">
                                    <svg class="icon-icon-arrow-down">
                                      <use xlink:href="#icon-arrow-down"></use>
                                    </svg></span><span class="country-legend__percentage">20%</span>
                                                    </div>
                                                </div>
                                                <div class="country-legend__item">
                                                    <div class="country-legend__left"><span class="country-legend__marker color-red"></span><span class="country-legend__name">China</span>
                                                    </div>
                                                    <div class="country-legend__trade"><span class="country-legend__quot quotation quotation--up">
                                    <svg class="icon-icon-arrow-down">
                                      <use xlink:href="#icon-arrow-down"></use>
                                    </svg></span><span class="country-legend__percentage">20%</span>
                                                    </div>
                                                </div>
                                                <div class="country-legend__item">
                                                    <div class="country-legend__left"><span class="country-legend__marker color-orange-dark"></span><span class="country-legend__name">France</span>
                                                    </div>
                                                    <div class="country-legend__trade"><span class="country-legend__quot quotation quotation--down">
                                    <svg class="icon-icon-arrow-down">
                                      <use xlink:href="#icon-arrow-down"></use>
                                    </svg></span><span class="country-legend__percentage">10%</span>
                                                    </div>
                                                </div>
                                                <div class="country-legend__item">
                                                    <div class="country-legend__left"><span class="country-legend__marker color-teal"></span><span class="country-legend__name">USA</span>
                                                    </div>
                                                    <div class="country-legend__trade"><span class="country-legend__quot quotation quotation--up">
                                    <svg class="icon-icon-arrow-down">
                                      <use xlink:href="#icon-arrow-down"></use>
                                    </svg></span><span class="country-legend__percentage">10%</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 d-flex">
                    <div class="card pb-0">
                        <div class="card__wrapper">
                            <div class="card__container">
                                <div class="card__header">
                                    <div class="card__header-left">
                                        <h3 class="card__header-title">Calendar</h3>
                                    </div>
                                    <div class="card__tools-more">
                                        <button class="items-more__button">
                                            <svg class="icon-icon-more">
                                                <use xlink:href="#icon-more"></use>
                                            </svg>
                                        </button>
                                        <div class="dropdown-items">
                                            <div class="dropdown-items__container">
                                                <ul class="dropdown-items__list">
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-refresh">
                                        <use xlink:href="#icon-refresh"></use>
                                      </svg></span>Refresh</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-settings">
                                        <use xlink:href="#icon-settings"></use>
                                      </svg></span>Settings</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-download">
                                        <use xlink:href="#icon-download"></use>
                                      </svg></span>Download</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-action">
                                        <use xlink:href="#icon-action"></use>
                                      </svg></span>Action</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__body">
                                    <div class="calendar-inline" id="calendarOne">
                                        <div class="js-calendar-inline"></div>
                                    </div>
                                </div>
                                <div class="card__footer card__footer--md">
                                    <div class="card__container">
                                        <div class="calendar-widget" data-calendar="#calendarOne">
                                            <div class="calendar-widget__row">
                                                <div class="calendar-widget__item calendar-widget__item--left">
                                                    <div class="calendar-widget__day"><span class="calendar-widget__dateday">13</span><sup class="calendar-widget__weekday text-grey">TH</sup>
                                                    </div>
                                                    <div class="calendar-widget__month text-grey">December</div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section">
            <div class="section__title d-none">
                <h2>Section</h2>
            </div>
            <div class="row gutter-bottom-xl">
                <div class="col-12 col-md-6 col-lg-6 col-xl-6 d-flex">
                    <div class="card">
                        <div class="card__wrapper">
                            <div class="card__container">
                                <div class="card__header">
                                    <div class="card__header-left">
                                        <h3 class="card__header-title">Credit Card</h3>
                                    </div>
                                    <div class="card__tools-more">
                                        <button class="items-more__button">
                                            <svg class="icon-icon-more">
                                                <use xlink:href="#icon-more"></use>
                                            </svg>
                                        </button>
                                        <div class="dropdown-items">
                                            <div class="dropdown-items__container">
                                                <ul class="dropdown-items__list">
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-refresh">
                                        <use xlink:href="#icon-refresh"></use>
                                      </svg></span>Refresh</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-settings">
                                        <use xlink:href="#icon-settings"></use>
                                      </svg></span>Settings</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-download">
                                        <use xlink:href="#icon-download"></use>
                                      </svg></span>Download</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-action">
                                        <use xlink:href="#icon-action"></use>
                                      </svg></span>Action</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__body">
                                    <div class="card__credit-card">
                                        <div class="credit-card">
                                            <img class="credit-card__image" src="<?php echo e(asset('auth-new/img/content/credit-card.svg')); ?>" alt="#" />
                                            <div class="credit-card__number-wrapper">
                                                <input class="credit-card__number-input" type="text" value="0123456789101112" readonly="readonly" />
                                                <div class="credit-card__number">
                                                    <div class="credit-card__number-item">

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="credit-card__name">
                                                <p><?php echo e(chunk_split(Auth::user()->credit_card_number_one, 4, ' ')); ?></p>
                                                <div class="credit-card__caption">Card Holder</div>
                                                <?php echo e(Auth::user()->fname); ?> <?php echo e(Auth::user()->lname); ?>

                                            </div>
                                            <div class="credit-card__date">
                                                <div class="credit-card__caption">Expire</div><span>12/24</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__footer">
                                    <div class="card__container">
                                        <div class="card__credit-list">
                                            <ul class="card-list">
                                                <li class="row row--xs">
                                                    <div class="card-list__title col-auto">Card Type</div>
                                                    <div class="card-list__value col">VISA</div>
                                                </li>
                                                <li class="row row--xs">
                                                    <div class="card-list__title col-auto">Card Holder</div>
                                                    <div class="card-list__value col"><?php echo e(Auth::user()->fname); ?> <?php echo e(Auth::user()->lname); ?></div>
                                                </li>
                                                <li class="row row--xs">
                                                    <div class="card-list__title col-auto">Expire</div>
                                                    <div class="card-list__value col">12/25</div>
                                                </li>
                                                <li class="row row--xs">
                                                    <div class="card-list__title col-auto">Card Number</div>
                                                    <div class="card-list__value col">
                                                        <?php echo e(chunk_split(Auth::user()->credit_card_number_one, 4, ' ')); ?>

                                                    </div>
                                                </li>
                                                <li class="row row--xs">
                                                    <div class="card-list__title col-auto">Balance</div>
                                                    <div class="card-list__value col">$<?php echo e(number_format(Auth::user()->accbal)); ?></div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-6 col-xl-6 d-flex">
                    <div class="card">
                        <div class="card__wrapper">
                            <div class="card__container">
                                <div class="card__header">
                                    <div class="card__header-left">
                                        <h3 class="card__header-title">Add New Card</h3>
                                    </div>
                                    <div class="card__tools-more">
                                        <button class="items-more__button">
                                            <svg class="icon-icon-more">
                                                <use xlink:href="#icon-more"></use>
                                            </svg>
                                        </button>
                                        <div class="dropdown-items">
                                            <div class="dropdown-items__container">
                                                <ul class="dropdown-items__list">
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link">
                                                            <span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-refresh">
                                        <use xlink:href="#icon-refresh"></use>
                                      </svg></span>Refresh</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link">
                                                            <span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-settings">
                                        <use xlink:href="#icon-settings"></use>
                                      </svg></span>Settings</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link">
                                                            <span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-download">
                                        <use xlink:href="#icon-download"></use>
                                      </svg></span>Download</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link">
                                                            <span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-action">
                                        <use xlink:href="#icon-action"></use>
                                      </svg></span>Action</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__body">
                                    <form class="add-card js-add-card-form" method="POST">
                                        <div class="form-group">
                                            <label class="form-label">Name on Card</label>
                                            <div class="input-group">
                                                <input class="input" type="text" placeholder="" required="required" />
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">Card Number</label>
                                            <div class="input-group input-group--append">
                                                <input class="input js-card-number" type="text" placeholder="****   ****   ****   1234" required="required" /><span class="input-group__append"><img class="add-card__input-number-logo" src="<?php echo e(asset('auth-new/img/content/visa-logo.png')); ?>" alt="#"/></span>
                                            </div>
                                        </div>
                                        <div class="row row--sm">
                                            <div class="form-group col">
                                                <label class="form-label">Expire Date</label>
                                                <div class="input-group">
                                                    <input class="input js-card-date" type="text" placeholder="" required="required" />
                                                </div>
                                            </div>
                                            <div class="form-group col">
                                                <label class="form-label">CVV Code</label>
                                                <div class="input-group">
                                                    <input class="input js-card-cvv" type="text" placeholder="***" required="required" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="add-card__submit">
                                            <button class="button button--primary button--block" type="submit"><span class="button__icon button__icon--left">
                                <svg class="icon-icon-plus">
                                  <use xlink:href="#icon-plus"></use>
                                </svg></span><span class="button__text">Add Card</span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section">
            <div class="section__title d-none">
                <h2>Section</h2>
            </div>
            <div class="row gutter-bottom-xl">
                <div class="col-12 d-flex">
                    <div class="card pb-0">
                        <div class="card__wrapper">
                            <div class="card__container">
                                <div class="card__header">
                                    <div class="card__header-left">
                                        <h3 class="card__header-title">Transactions</h3>
                                    </div>
                                    <div class="card__tools-more">
                                        <button class="items-more__button">
                                            <svg class="icon-icon-more">
                                                <use xlink:href="#icon-more"></use>
                                            </svg>
                                        </button>
                                        <div class="dropdown-items">
                                            <div class="dropdown-items__container">
                                                <ul class="dropdown-items__list">
                                                    <li class="dropdown-items__item">
                                                        <a class="dropdown-items__link">
                                                            <span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-refresh">
                                        <use xlink:href="#icon-refresh"></use>
                                      </svg></span>Refresh</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-settings">
                                        <use xlink:href="#icon-settings"></use>
                                      </svg></span>Settings</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-download">
                                        <use xlink:href="#icon-download"></use>
                                      </svg></span>Download</a>
                                                    </li>
                                                    <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                      <svg class="icon-icon-action">
                                        <use xlink:href="#icon-action"></use>
                                      </svg></span>Action</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card__body">
                                    <div class="card__scrollbar card__table">
                                        <div class="card__table-transactions scrollbar-thin scrollbar-visible" data-simplebar="data-simplebar">
                                            <table class="table table--lines table--striped">
                                                <colgroup>
                                                    <col class="colgroup-1" />
                                                    <col class="colgroup-2" />
                                                    <col class="colgroup-3" />
                                                    <col class="colgroup-4" />
                                                    <col class="colgroup-5" />
                                                    <col class="colgroup-6" />
                                                    <col/>
                                                </colgroup>
                                                <thead class="table__header table__header--sticky">

                                                <tr>
                                                    <th>
                                                        <span class="text-nowrap">Transaction Date</span>
                                                    </th>
                                                    <th>
                                                        <span>Reference Number</span>
                                                    </th>
                                                    <th>
                                                        <span>Description</span>
                                                    </th>
                                                    <th>
                                                        <span>Credit Balance</span>
                                                    </th>
                                                    <th>
                                                        <span>Debit</span>
                                                    </th>
                                                    <th>
                                                        <span>Credit</span>
                                                    </th>
                                                    <th class="table__actions"></th>
                                                </tr>

                                                </thead>
                                                <tbody>

                                                <?php if($transactions): ?>
                                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="table__row">
                                                    <td class="table__td">
                                                        <span class="text-grey">
                                                            <?php echo e(date('jS \of F Y', strtotime($trans->created_at))); ?>

                                                        </span>
                                                    </td>
                                                    <td class="table__td">
                                                        <?php echo e($trans->ref); ?>

                                                    </td>
                                                    <td class="table__td">
                                                        <span class="text-grey">
                                                            <?php echo e($trans->description); ?>

                                                        </span>
                                                    </td>
                                                    <td class="table__td">
                                                        <span>$<?php echo e(number_format($trans->currbal, 0)); ?></span>
                                                    </td>
                                                    <td class="table__td">
                                                        <span class="text-grey">
                                                            <?php echo e(!empty($trans->debit) ? '$'.number_format($trans->debit, 0):''); ?>

                                                        </span>
                                                    </td>
                                                    <td class="table__td">
                                                        <span class="text-grey">
                                                            <?php echo e(!empty($trans->debit) ? '$'.number_format($trans->debit, 0):''); ?>

                                                        </span>
                                                    </td>
                                                    <td class="table__td table__actions">
                                                        <div class="items-more">
                                                            <button class="items-more__button">
                                                                <svg class="icon-icon-more">
                                                                    <use xlink:href="#icon-more"></use>
                                                                </svg>
                                                            </button>
                                                            <div class="dropdown-items dropdown-items--right">
                                                                <div class="dropdown-items__container">
                                                                    <ul class="dropdown-items__list">
                                                                        <li class="dropdown-items__item">
                                                                            <a class="dropdown-items__link">
                                                                                <span class="dropdown-items__link-icon">
                                                  <svg class="icon-icon-view">
                                                    <use xlink:href="#icon-view"></use>
                                                  </svg></span>Details</a>
                                                                        </li>
                                                                        <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                                  <svg class="icon-icon-duplicate">
                                                    <use xlink:href="#icon-duplicate"></use>
                                                  </svg></span>Duplicate</a>
                                                                        </li>
                                                                        <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                                  <svg class="icon-icon-archive">
                                                    <use xlink:href="#icon-archive"></use>
                                                  </svg></span>Archive</a>
                                                                        </li>
                                                                        <li class="dropdown-items__item"><a class="dropdown-items__link"><span class="dropdown-items__link-icon">
                                                  <svg class="icon-icon-trash">
                                                    <use xlink:href="#icon-trash"></use>
                                                  </svg></span>Delete</a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('bottom-assets'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.users_new', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ocearhxe/public_html/bank.oceaniccapitalventures.com/resources/views/users/index.blade.php ENDPATH**/ ?>