

<?php $__env->startSection('title'); ?>
All Transactions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>

<div class="card" id="">
        <div class="card-body">
            <h4 id="rw-dt-responsive">All Transactions</h4>
            <table id="dt-example-responsive" class="table table-bordered" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th width="">
                            Name
                        </th>
                        <th width="">
                            Transaction Date
                        </th>
                        <th width="">
                            Reference Number
                        </th>
                        <th width="">
                            Description
                        </th>
                        <th width="">
                            Credit Balance
                        </th>
                        <th width="">
                            Debit
                        </th>
                        <th width="">
                            Credit
                        </th>
                        <th width="">
                            Edit
                        </th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th width="">
                            Name
                        </th>
                        <th width="">
                            Transaction Date
                        </th>
                        <th width="">
                            Reference Number
                        </th>
                        <th width="">
                            Description
                        </th>
                        <th width="">
                            Credit Balance
                        </th>
                        <th width="">
                            Debit
                        </th>
                        <th width="">
                            Credit
                        </th>
                        <th width="">
                            Edit
                        </th>
                    </tr>
                </tfoot>

                <tbody>
                    <?php if($transactions): ?>
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td width="">
                            <?php echo e($trans->user ? $trans->user->fname : ''); ?> <?php echo e($trans->user ? $trans->user->lname : ''); ?>

                        </td>
                        <td width="">
                            <?php echo e(date('jS \of F Y', strtotime($trans->created_at))); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->ref); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->description); ?>

                        </td>
                        <td width="">
                            $<?php echo e(number_format($trans->currbal, 0)); ?>

                        </td>
                        <td width="">
                            <?php echo e(!empty($trans->debit) ? '$'.number_format($trans->debit, 0):''); ?>

                        </td>
                        <td width="">
                            <?php echo e(!empty($trans->credit) ? '$'.number_format($trans->credit, 0):''); ?>

                        </td>
                        <td width="">
                            <a class="dropdown-item" href="<?php echo e(url('admin/change-date/'.$trans->id)); ?>">
                                <button class="btn btn-info btn-sm">Change Date</button>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                </tbody>
            </table>

            <script type="text/javascript">
                document.addEventListener("DOMContentLoaded", function() {
                    app._loading.show($("#dt-ext-responsive"), {
                        spinner: true
                    });
                    $("#dt-example-responsive").DataTable({
                        "responsive": true,
                        "initComplete": function(settings, json) {
                            setTimeout(function() {
                                app._loading.hide($("#dt-ext-responsive"));
                            }, 1000);
                        }
                    });
                });
            </script>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
<!-- THIS PAGE SCRIPTS ONLY -->
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/datatables/datatables.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/datatables/extensions/dataTables.responsive.min.js')); ?>"></script>
<!-- //END THIS PAGE SCRIPTS ONLY -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ocearhxe/public_html/online.oceaniccapitalventures.com/resources/views/admin/all-transactions.blade.php ENDPATH**/ ?>