

<?php $__env->startSection('title'); ?>
All Transfers
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>

<div class="card" id="">
        <div class="card-body">
            <h4 id="rw-dt-responsive">All Transfers</h4>
            <table id="dt-example-responsive" class="table table-bordered" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th width="">
                            Name
                        </th>
                        <th width="">
                            Receiver
                        </th>
                        <th width="">
                            Amount
                        </th>
                        <th width="">
                            Currency Conversion
                        </th>
                        <th width="">
                            Cost of Transfer
                        </th>
                        <th width="">
                            Tax  Revenue
                        </th>
                        <th width="">
                            Ref
                        </th>
                        <th width="">
                            OTP
                        </th>
                        <th width="">
                            Status
                        </th>
                        <th width="">
                            Date
                        </th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th width="">
                            Name
                        </th>
                        <th width="">
                            Receiver
                        </th>
                        <th width="">
                            Amount
                        </th>
                        <th width="">
                            Currency Conversion
                        </th>
                        <th width="">
                            Cost of Transfer
                        </th>
                        <th width="">
                            Tax  Revenue
                        </th>
                        <th width="">
                            Ref
                        </th>
                        <th width="">
                            OTP
                        </th>
                        <th width="">
                            Status
                        </th>
                        <th width="">
                            Date
                        </th>
                    </tr>
                </tfoot>

                <tbody>
                    <?php if($transfers): ?>
                    <?php $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td width="">
                            <?php echo e($trans->user ? $trans->user->fname .' '. $trans->user->fname : ''); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->recbank); ?><br>
                            <?php echo e($trans->recaccname); ?><br>
                            <?php echo e($trans->recaccnum); ?>

                        </td>
                        <td width="">
                            $<?php echo e($trans->amt); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->currency_conversion); ?><br>
                            <?php echo e($trans->currency_conversion_charge); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->cost_of_transfer); ?><br>
                            <?php echo e($trans->cost_of_transfer_charge); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->tax_revenue); ?><br>
                            <?php echo e($trans->tax_revenue_charge); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->ref); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->otp); ?>

                        </td>
                        <td width="">
                            <?php echo e($trans->status); ?>

                        </td>
                        <td width="">
                            <?php echo e(date('jS \of F Y', strtotime($trans->created_at))); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                </tbody>
            </table>

            <script type="text/javascript">
                document.addEventListener("DOMContentLoaded", function() {
                    app._loading.show($("#dt-ext-responsive"), {
                        spinner: false
                    });
                    $("#dt-example-responsive").DataTable({
                        "responsive": true,
                        "initComplete": function(settings, json) {
                            setTimeout(function() {
                                app._loading.hide($("#dt-ext-responsive"));
                            }, 1000);
                        }
                    });
                });
            </script>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
<!-- THIS PAGE SCRIPTS ONLY -->
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/datatables/datatables.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/datatables/extensions/dataTables.responsive.min.js')); ?>"></script>
<!-- //END THIS PAGE SCRIPTS ONLY -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ocearhxe/public_html/online.oceaniccapitalventures.com/resources/views/admin/fund-transfers.blade.php ENDPATH**/ ?>