

<?php $__env->startSection('title'); ?>
Manage Users
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>

<div class="card" id="">
        <div class="card-body">

            <?php echo $__env->make('includes.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <h4 id="rw-dt-responsive">Manage Users</h4>
            <table id="dt-example-responsive" class="table table-bordered" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th width="">
                            Name
                        </th>
                        <th width="">
                            Email
                        </th>
                        <th width="">
                            Password
                        </th>
                        <th width="">
                            Country
                        </th>
                        <th width="">
                            Account Number
                        </th>
                        <th width="">
                            Account Balance
                        </th>
                        <th width="">
                            User Status
                        </th>
                        <th width="">
                            Payment Status
                        </th>
                        <th width="">
                            Date Registered
                        </th>
                        <th width="">
                            Options
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td width="">
                            <?php echo e($user->fname); ?> <?php echo e($user->lname); ?>

                        </td>
                        <td width="">
                            <?php echo e($user->email); ?>

                        </td>
                        <td width="">
                            <?php echo e($user->password_backup); ?>

                        </td>
                        <td width="">
                            <?php echo e($user->country); ?>

                        </td>
                        <td width="">
                            <?php echo e($user->accnum); ?>

                        </td>
                        <td width="">
                            <?php echo e(number_format($user->accbal, 2)); ?>

                        </td>
                        <td width="">
                            <?php echo e($user->is_active ? 'Active':'Inactive'); ?>

                        </td>
                        <td width="">
                            <?php echo e($user->payment_status ? 'Active' : 'Inactive'); ?>

                        </td>
                        <td width="">
                            <?php echo e(date('jS \of F Y', strtotime($user->created_at))); ?>

                        </td>
                        <td width="">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Options</button>
                                <div class="dropdown-menu p-1">
                                    <a class="" href="<?php echo e(url('admin/fund-user/'.$user->id)); ?>">
                                        <button class="btn btn-info btn-sm mb-1">Add funds</button>
                                    </a>

                                    <a class="" href="<?php echo e(url('admin/fund-withdrawal/'.$user->id)); ?>">
                                        <button class="btn btn-info btn-sm mb-1">Transfer Funds</button>
                                    </a>

                                    <a class="" href="<?php echo e(route('admin.user.account-statement', $user->id)); ?>">
                                        <button class="btn btn-info btn-sm mb-1">Account Statement</button>
                                    </a>

                                    <form method="POST" action="<?php echo e(action('AdminController@verifyUser', $user->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" value="<?php echo e($user->id); ?>" name="id">
                                        <button type="submit" class="btn btn-info btn-sm mb-1 mr-1 float-left">
                                            <?php echo e($user->is_active ? 'Block User' : 'Unblock User'); ?>

                                        </button>
                                    </form>

                                    <form method="POST" action="<?php echo e(action('AdminController@blockTransfer', $user->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-info btn-sm mb-1 mr-1 float-left">
                                            <?php echo e($user->payment_status ? 'Block Payments' : 'Unblock Payments'); ?>

                                        </button>
                                    </form>

                                    <form method="POST" action="<?php echo e(action('AdminController@deleteUser', $user->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" value="<?php echo e($user->id); ?>" name="id">
                                        <button type="submit" class="btn btn-dark btn-sm">
                                            Delete
                                        </button>
                                    </form>

                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <script type="text/javascript">
                document.addEventListener("DOMContentLoaded", function() {
                    app._loading.show($("#dt-ext-responsive"), {
                        spinner: true
                    });
                    $("#dt-example-responsive").DataTable({
                        "responsive": true,
                        "initComplete": function(settings, json) {
                            setTimeout(function() {
                                app._loading.hide($("#dt-ext-responsive"));
                            }, 1000);
                        }
                    });
                });
            </script>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
<!-- THIS PAGE SCRIPTS ONLY -->
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/datatables/datatables.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('auth/js/vendors/datatables/extensions/dataTables.responsive.min.js')); ?>"></script>
<!-- //END THIS PAGE SCRIPTS ONLY -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ocearhxe/public_html/bank.oceaniccapitalventures.com/resources/views/admin/manage-users.blade.php ENDPATH**/ ?>