

<?php $__env->startSection('title'); ?>
Fund User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>

<div class="card">
    <div class="card-body">
        <h4 id="rw-fl-row">Fund <?php echo e($user->fname); ?> <?php echo e($user->lname); ?>'s Account</h4>
        <h5 id="rw-fl-row">Current Balance: $<?php echo e($user->accbal); ?></h5>
        <p class="subtitle margin-bottom-20">Fill in the amount</p>

        <?php echo $__env->make('includes.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form method="post" action="<?php echo e(action('AdminController@fundUser', $user->id)); ?>">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label>Sender Account Name *</label>
                <input type="text" class="form-control" name="sendaccname" placeholder="Sender Account Name" required>
            </div>

            <div class="form-group">
                <label>Sender Account Number *</label>
                <input type="number" class="form-control" name="sendaccnum" placeholder="Sender Account Number" required>
            </div>

            <div class="form-group">
                <label>Sender Bank *</label>
                <input type="text" class="form-control" name="sendbank" placeholder="Sender bank" required>
            </div>

            <div class="form-group">
                <label>Amount to Transfer USD$ *</label>
                <input type="text" class="form-control amount" name="amt"
                       placeholder="Amount to Transfer USD$" required>
            </div>

            <div class="form-group">
                <label>Description *</label>
                <textarea name="description" class="form-control"></textarea>
            </div>

            <button type="submit" class="btn btn-secondary">Fund User</button>
        </form>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <script>
        $(document).ready(function(){

            // Add commas to amount input
            $("input.amount").on("keyup change", function(e) {
                // Limit to only numbers
                this.value = this.value.replace(/\D/g,'');
                // skip for arrow keys
                if(e.which >= 37 && e.which <= 40) return;
                // format number
                $(this).val((index, value) => {
                    return value
                        .replace(/\D/g, "")
                        .replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                });
                console.log($(this).val())
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ocearhxe/public_html/online.oceaniccapitalventures.com/resources/views/admin/fund-user.blade.php ENDPATH**/ ?>